// Universal ID Collector - Background Script
console.log('🚀 Universal ID Collector background script loaded');

// Основной обработчик сообщений
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('📨 Background received message:', request.action, 'from tab:', sender.tab?.id);
  
  // Обработка разных типов сообщений
  switch (request.action) {
    case 'parsersUpdated':
    case 'settingsUpdated':
      // Пересылаем в popup если открыт
      chrome.runtime.sendMessage(request).catch(error => {
        // Это нормально - popup может быть закрыт
        if (!error.message.includes('Receiving end does not exist')) {
          console.warn('❌ Error forwarding to popup:', error);
        }
      });
      break;
      
    case 'showNotification':
    case 'toggleAutoScan':
      // Пересылаем в активную вкладку
      chrome.tabs.query({ active: true, currentWindow: true }).then(tabs => {
        if (tabs[0]?.id) {
          chrome.tabs.sendMessage(tabs[0].id, request).catch(error => {
            if (!error.message.includes('Receiving end does not exist')) {
              console.warn('❌ Error forwarding to tab:', error);
            }
          });
        }
      });
      break;
  }
  
  // Не держим соединение открытым
  return false;
});

// Обработчик установки
chrome.runtime.onInstalled.addListener((details) => {
  console.log('✅ Extension installed/updated:', details.reason);
  
  if (details.reason === 'install') {
    // Устанавливаем настройки по умолчанию
    chrome.storage.local.set({
      enabled: true,
      firstInstall: true
    });
  }
});

console.log('✅ Background script ready');